package parametricTypes

object ParametricExample {
  
  // a parametric product type
  case class Prod[A,B](val pi1: A, val pi2: B)
  
  // a parametric sum type
  sealed trait Sum[A,B]
  case class In1[A,B](val a: A) extends Sum[A,B]
  case class In2[A,B](val b: B) extends Sum[A,B]
  
  // a parametric function type
  type Fun[A,B] = A => B
  
  def main(args: Array[String]) = {
    //===============================================================
    // product
    
    // introduction
    val p: Prod[Int, String] = Prod(3, "shrdlu")
    // here the type is automatically inferred to be Prod[Char, Boolean]
    val q = Prod('a', true)   
    // elimination
    println("p.pi1 = " + p.pi1 + ", p.pi2 = " + p.pi2)
    println("q.pi1 = " + q.pi1 + ", q.pi2 = " + q.pi2)
    
    println("===========================")
    
    //===============================================================
    // sum
    
    // introduction
    val r: Sum[Int, String] = In1(4)
    val s: Sum[Char, Boolean] = In2(true)
    // elimination
    r match {
      case In1(a) => println("In1: " + a)
      case In2(b) => println("In2: " + b)
    }
    s match {
      case In1(a) => println("In1: " + a)
      case In2(b) => println("In2: " + b)
    }

    //===============================================================
    // function
    
    // introduction
    val f: Fun[Int, String] = i => "output = " + i
    // elimination
    println(f(42))
    
  }
}